/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.clientupdater;

import com.pwemu.clientupdater.CPWCreator;
import com.pwemu.clientupdater.CPWDB;
import com.pwemu.framework.crypt.RsaSha1;
import com.pwemu.framework.servise.LoggingService;
import com.pwemu.framework.utils.Config;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class CPW {
    private static final Logger log = Logger.getLogger(CPW.class);
    private static final String CONFIG_FILE = "config/patcher.conf";
    private static final String SQL_FILE = "config/install.sql";
    public static Config conf;
    public static RsaSha1 newRsa;
    public static File patchdir;
    public static CPWDB dbms;

    private static void preLoad() {
        LoggingService.init();
        conf = Config.getConfig(CONFIG_FILE);
    }

    private static void loadDb() {
        try {
            dbms = new CPWDB("com.mysql.jdbc.Driver", "jdbc:mysql://" + conf.getProperty("mysql-host", "localhost") + ":" + conf.getProperty("mysql-port", "3306") + "/" + conf.getProperty("mysql-db", "dbu") + "?characterSetResults=UTF-8&characterEncoding=UTF-8&useUnicode=yes", conf.getProperty("mysql-user", "root"), conf.getProperty("mysql-password", ""));
        }
        catch (ClassNotFoundException ex) {
            log.fatal((Object)"Database connection error: cannot find driver.", (Throwable)ex);
        }
        catch (SQLException ex) {
            log.fatal((Object)"Database error: SQL exception.", (Throwable)ex);
        }
        if (!dbms.isConnected()) {
            log.error((Object)"Database not connected.");
        }
    }

    private static void loadRsa() {
        newRsa = new RsaSha1(new BigInteger(conf.getProperty("rsa-private-x")), new BigInteger(conf.getProperty("rsa-public-x")), new BigInteger(conf.getProperty("rsa-modus")));
    }

    public static void main(String[] args) {
        CPW.preLoad();
        if (args.length > 0) {
            if (args[0].compareToIgnoreCase("install") == 0) {
                log.info((Object)"Installing...");
                CPW.rsagen();
                CPW.install();
            } else if (args[0].compareToIgnoreCase("rsagen") == 0) {
                log.info((Object)"Running RSA keygen.");
                CPW.rsagen();
            } else if (args[0].compareToIgnoreCase("initial") == 0) {
                log.info((Object)"Running initial.");
                CPW.initial();
            } else if (args[0].compareToIgnoreCase("new") == 0 || args[0].compareToIgnoreCase("revision") == 0) {
                log.info((Object)"Creating patch.");
                if (args.length > 1) {
                    CPW.revision(Integer.parseInt(args[1]));
                } else {
                    CPW.revision();
                }
            } else if (args[0].compareToIgnoreCase("listgen") == 0 || args[0].compareToIgnoreCase("listupdate") == 0) {
                log.info((Object)"Running list generator.");
                CPW.listupdate();
            } else if ((args[0].compareToIgnoreCase("x") == 0 || args[0].compareToIgnoreCase("patch") == 0) && args.length > 1) {
                log.info((Object)"Running exe patcher.");
                String[] files = new String[args.length - 1];
                System.arraycopy(args, 1, files, 0, args.length - 1);
                CPW.patchX(files);
            }
        } else {
            CPW.menu();
        }
    }

    public static void install() {
        Scanner in = new Scanner(System.in);
        log.info((Object)"Input mysql server (eg, localhost):");
        String host = in.nextLine();
        log.info((Object)"Input mysql login (eg, pwu):");
        String username = in.nextLine();
        log.info((Object)"Input mysql password (eg, superpuperpassword):");
        String password = in.nextLine();
        log.info((Object)"Input mysql database name (eg, pwu):");
        String dbname = in.nextLine();
        conf.setProperty("mysql-host", host);
        conf.setProperty("mysql-user", username);
        conf.setProperty("mysql-password", password);
        conf.setProperty("mysql-db", dbname);
        log.info((Object)"Saving config.");
        conf.save();
        log.info((Object)"Creating table.");
        CPW.loadDb();
        dbms.executeFromFile(new File(SQL_FILE));
        log.info((Object)("Install complete.\nNow unpack your client using provided instuctions. Afterwards place unpacked files under " + conf.getProperty("patch-path") + "/" + conf.getProperty("patch-new-dir") + "/"));
    }

    public static void rsagen() {
        log.info((Object)"Creating rsa keys...");
        newRsa = new RsaSha1();
        conf.setProperty("rsa-modus", newRsa.getModus());
        conf.setProperty("rsa-public-x", newRsa.getPublicX());
        conf.setProperty("rsa-public-key", newRsa.getPublicKey());
        conf.setProperty("rsa-private-x", newRsa.getPrivateX());
        conf.setProperty("rsa-private-key", newRsa.getPrivateKey());
        newRsa.printKeys();
        log.info((Object)"Saving keys.");
        conf.save();
    }

    public static void initial() {
        CPW.loadDb();
        CPW.loadRsa();
        log.info((Object)"Creating initial patch data.");
        patchdir = new File(conf.getProperty("patch-path"));
        String newfiles = patchdir.getPath() + "/" + conf.getProperty("patch-new-dir") + "/";
        String cpwfiles = patchdir.getPath() + "/" + conf.getProperty("patch-cpw-dir") + "/";
        log.info((Object)("Using new files location = " + newfiles));
        log.info((Object)("Using patch output folder = " + cpwfiles));
        CPWCreator patcher = new CPWCreator(newfiles, cpwfiles);
        try {
            patcher.initial();
        }
        catch (Exception e) {
            log.error((Object)"Error while creating ", (Throwable)e);
        }
    }

    public static void revision() {
        CPW.loadDb();
        CPW.loadRsa();
        log.info((Object)"Creating next patch data.");
        patchdir = new File(conf.getProperty("patch-path"));
        String newfiles = patchdir.getPath() + "/" + conf.getProperty("patch-new-dir") + "/";
        String cpwfiles = patchdir.getPath() + "/" + conf.getProperty("patch-cpw-dir") + "/";
        log.info((Object)("Using new files location = " + newfiles));
        log.info((Object)("Using patch output folder = " + cpwfiles));
        CPWCreator patcher = new CPWCreator(newfiles, cpwfiles);
        try {
            patcher.revision();
        }
        catch (Exception e) {
            log.error((Object)"Error while creating ", (Throwable)e);
        }
    }

    public static void revision(int version) {
        CPW.loadDb();
        CPW.loadRsa();
        log.info((Object)("Creating patch " + version + " data."));
        patchdir = new File(conf.getProperty("patch-path"));
        String newfiles = patchdir.getPath() + "/" + conf.getProperty("patch-new-dir") + "/";
        String cpwfiles = patchdir.getPath() + "/" + conf.getProperty("patch-cpw-dir") + "/";
        log.info((Object)("Using new files location = " + newfiles));
        log.info((Object)("Using patch output folder = " + cpwfiles));
        CPWCreator patcher = new CPWCreator(newfiles, cpwfiles);
        try {
            patcher.revision(version);
        }
        catch (Exception e) {
            log.error((Object)"Error while creating ", (Throwable)e);
        }
    }

    public static void listupdate() {
        CPW.loadDb();
        CPW.loadRsa();
        log.info((Object)"Updating lists.");
        patchdir = new File(conf.getProperty("patch-path"));
        String newfiles = patchdir.getPath() + "/" + conf.getProperty("patch-new-dir") + "/";
        String cpwfiles = patchdir.getPath() + "/" + conf.getProperty("patch-cpw-dir") + "/";
        log.info((Object)("Using new files location = " + newfiles));
        log.info((Object)("Using patch output folder = " + cpwfiles));
        CPWCreator patcher = new CPWCreator(newfiles, cpwfiles);
        try {
            patcher.listgen();
        }
        catch (Exception e) {
            log.error((Object)"Error while creating ", (Throwable)e);
        }
    }

    public static void patchX(String[] files) {
        CPW.loadRsa();
        for (String filey : files) {
            try {
                log.info((Object)("Patching " + filey));
                newRsa.patchFile(new File(filey));
            }
            catch (IOException ex) {
                log.error((Object)("Can't open " + filey), (Throwable)ex);
            }
        }
    }

    public static void menu() {
        System.out.println("Usage:");
        System.out.println("\t./cpw\t\t\t\t\tshow this message\n");
        System.out.println("\t./cpw install\t\t\t\tinstall updater: mysql database setup, rsa keys generation, paths.");
        System.out.println("\t./cpw rsagen \t\t\t\tregenerate rsa keys");
        System.out.println("\t./cpw x [executable] \t\t\tpatches executable with public rsa key\n");
        System.out.println("\t./cpw initial\t\t\t\tcreates initial (base) revision, doesn't creates lists");
        System.out.println("\t./cpw new [revision number]  \t\tcreates next or given revision, creates lists");
        System.out.println("\t./cpw revision [revision number]     \tcreates next or given revision, creates lists");
        System.out.println("\t./cpw listgen\t\t\t\tupdate lists only");
        System.out.println("\t./cpw listupdate     \t\t\tupdate lists only");
    }

    static {
        patchdir = null;
        dbms = null;
    }
}

