/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.clientupdater;

import com.pwemu.clientupdater.CPW;
import com.pwemu.framework.crypt.Base64;
import com.pwemu.framework.utils.CRCSum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.zip.Deflater;
import org.apache.log4j.Logger;

public class CPWCreator {
    private static final Logger log = Logger.getLogger(CPWCreator.class);
    private File newcontent = null;
    private File cpwcontent = null;
    private String[] folders = new String[]{"element", "launcher", "patcher"};
    private Hashtable<String, Integer> currentRevisions = new Hashtable(3);
    private Hashtable<String, Integer> nextRevisions = new Hashtable(3);
    private Hashtable<String, String> source = new Hashtable(3);
    private Hashtable<String, String> destination = new Hashtable(3);

    public CPWCreator(String newcontent, String cpwcontent) {
        try {
            this.getDbRevisions();
        }
        catch (SQLException ex) {
            log.error((Object)"CPWCreator unable to connect mysql.", (Throwable)ex);
        }
        this.newcontent = new File(newcontent);
        this.cpwcontent = new File(cpwcontent);
    }

    private void getDbRevisions() throws SQLException {
        Statement st = CPW.dbms.link().createStatement();
        for (String type : this.folders) {
            int dbValue = 0;
            int configValue = Integer.valueOf(CPW.conf.getProperty("min-" + type + "-ver", "1"));
            ResultSet rs = st.executeQuery("SELECT MAX(`revision`) FROM `files` WHERE `type`='" + type + "'");
            if (rs.next()) {
                dbValue = rs.getInt(1);
            } else {
                --configValue;
            }
            if (configValue > dbValue) {
                dbValue = configValue;
            }
            this.currentRevisions.put(type, dbValue);
            this.nextRevisions.put(type, dbValue + 1);
        }
    }

    private void getDbRevision(String type) throws SQLException {
        Statement st = CPW.dbms.link().createStatement();
        int dbValue = 0;
        int configValue = Integer.valueOf(CPW.conf.getProperty("min-" + type + "-ver", "1"));
        ResultSet rs = st.executeQuery("SELECT MAX(`revision`) FROM `files` WHERE `type`='" + type + "'");
        if (rs.next()) {
            dbValue = rs.getInt(1);
        } else {
            --configValue;
        }
        if (configValue > dbValue) {
            dbValue = configValue;
        }
        this.currentRevisions.put(type, dbValue);
        this.nextRevisions.put(type, dbValue + 1);
    }

    private long getTotalSize(String type, int from, int to) throws SQLException {
        long sum = 0L;
        Statement st = CPW.dbms.link().createStatement();
        ResultSet rs = st.executeQuery("SELECT SUM(`size`) AS `sum` FROM `files` WHERE `type`='" + type + "' AND `revision` BETWEEN '" + from + "' AND '" + to + "'");
        if (rs.next()) {
            sum = rs.getLong("sum");
        }
        return sum;
    }

    public void initial() throws IOException, Exception {
        for (String type : this.folders) {
            this.nextRevisions.put(type, (int)Integer.valueOf(CPW.conf.getProperty("min-" + type + "-ver", "1")));
        }
        this.revision();
    }

    public void revision() throws IOException, Exception {
        if (!this.newcontent.isDirectory() || !this.cpwcontent.isDirectory()) {
            log.error((Object)"Directorys error.");
        }
        log.info((Object)"Updating...");
        for (String type : this.folders) {
            log.info((Object)("Updating " + type + "..."));
            if (this.update(type) && this.createLists(type)) {
                log.info((Object)"Success.");
                continue;
            }
            log.fatal((Object)("Failed to update " + type + "."));
        }
    }

    public void revision(int revision) throws IOException, Exception {
        this.nextRevisions.put("element", revision);
        this.revision();
    }

    public void listgen() throws IOException, SQLException, Exception {
        for (String type : this.folders) {
            log.info((Object)("Updating lists " + type + "..."));
            if (this.createLists(type)) {
                log.info((Object)"Success.");
                continue;
            }
            log.fatal((Object)("Failed to update " + type + "."));
        }
    }

    private boolean createFolder(File location) {
        if (location.exists() && location.isDirectory()) {
            return true;
        }
        return location.mkdir();
    }

    private String getUnpackedFilePath(String type, String fullpath) {
        return fullpath.substring(this.source.get(type).length()).replace("\\", "/");
    }

    private String getPackedFilePath(String type, String fullpath) {
        return fullpath.substring(this.destination.get(type).length()).replace("\\", "/");
    }

    private String getFolderPath(String path) {
        return path.substring(0, path.lastIndexOf("/") + 1);
    }

    private String getFileName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private String base64Path(String path) {
        path = path.replace("\\", "/");
        String[] pathz = path.split("/");
        String output = "";
        for (int i = 0; i < pathz.length; ++i) {
            output = output + "/" + this.base64(pathz[i]);
        }
        return output;
    }

    private String base64(String what) {
        what = what.replace("\\", "/");
        what = what.replace("/", "");
        String output = Base64.encodeBytes(what.getBytes(Charset.forName("UTF-8"))).toString();
        while (output.indexOf("/") > 0) {
            output = output.replace("/", "-");
        }
        return output;
    }

    private boolean updateDatabase(String type, String md5, String file, String file_base64, String folder, String folder_base64, Long file_size) throws SQLException {
        int updateCount = 0;
        Statement st = CPW.dbms.link().createStatement();
        ResultSet rs = st.executeQuery("SELECT md5 FROM `files` WHERE `type`='" + type + "' AND `folder_base64`='" + folder_base64 + "' AND `file_base64`='" + file_base64 + "'");
        if (rs.next()) {
            updateCount = rs.getString(1).compareTo(md5) != 0 ? st.executeUpdate("UPDATE `files` SET `md5`='" + md5 + "', `revision`='" + this.nextRevisions.get(type) + "', `size`='" + file_size + "' WHERE `type`='" + type + "' AND `folder_base64`='" + folder_base64 + "' AND `file_base64`='" + file_base64 + "'") : ++updateCount;
        } else {
            st.executeUpdate("SET NAMES `utf8`");
            updateCount = st.executeUpdate("INSERT INTO `files` (`added`,`size`,`revision`,`md5`,`type`,`folder`,`folder_base64`,`file`,`file_base64`) VALUES ('" + this.nextRevisions.get(type) + "','" + file_size + "','" + this.nextRevisions.get(type) + "','" + md5 + "','" + type + "','" + folder.replaceAll("'", "-") + "','" + folder_base64 + "','" + file.replaceAll("'", "-") + "','" + file_base64 + "')");
        }
        return updateCount != 0;
    }

    private boolean createLists(String type) throws Exception, SQLException, IOException {
        int revisioncurrent;
        String lastfolder = "";
        this.getDbRevision(type);
        int revision = this.currentRevisions.get(type);
        boolean filesizeadd = Boolean.valueOf(CPW.conf.getProperty("add-size", "false"));
        Statement st = CPW.dbms.link().createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM `files` WHERE `type`='" + type + "' ORDER BY `revision`, `folder_base64`");
        File filesmd5 = new File(this.cpwcontent.getAbsolutePath() + "/" + type + "/files.md5");
        filesmd5.createNewFile();
        FileOutputStream filesmd5OutputStream = new FileOutputStream(filesmd5);
        ((OutputStream)filesmd5OutputStream).write(new String("# " + revision + "\n").getBytes("ISO-8859-1"));
        while (rs.next()) {
            String folder = rs.getString("folder_base64");
            String file = rs.getString("file_base64");
            String md5 = rs.getString("md5");
            if (lastfolder.compareTo(folder) != 0) {
                lastfolder = folder;
                ((OutputStream)filesmd5OutputStream).write(new String(md5 + " " + folder + file + "\n").getBytes());
                continue;
            }
            ((OutputStream)filesmd5OutputStream).write(new String(md5 + " " + file + "\n").getBytes());
        }
        CPW.newRsa.doSignature(filesmd5, filesmd5OutputStream);
        filesmd5OutputStream.flush();
        ((OutputStream)filesmd5OutputStream).close();
        int minimumrevision = revisioncurrent = Integer.valueOf(CPW.conf.getProperty("min-" + type + "-ver", "1")).intValue();
        while (revisioncurrent < revision) {
            rs.first();
            File vxfile = new File(this.cpwcontent.getAbsolutePath() + "/" + type + "/v-" + (revision - revisioncurrent) + ".inc");
            vxfile.createNewFile();
            FileOutputStream vxfileOutputStream = new FileOutputStream(vxfile);
            if (filesizeadd) {
                ((OutputStream)vxfileOutputStream).write(new String("# " + revisioncurrent + " " + revision + " " + this.getTotalSize(type, revisioncurrent, revision) + "\n").getBytes());
            } else {
                ((OutputStream)vxfileOutputStream).write(new String("# " + revisioncurrent + " " + revision + "\n").getBytes());
            }
            lastfolder = "";
            do {
                if (rs.getInt("revision") == minimumrevision || revisioncurrent >= rs.getInt("revision")) continue;
                String folder = rs.getString("folder_base64");
                String file = rs.getString("file_base64");
                String md5 = rs.getString("md5");
                int added = rs.getInt("added");
                String pre = "!";
                if (added >= revisioncurrent && added != minimumrevision) {
                    pre = "+";
                }
                if (lastfolder.compareTo(folder) != 0) {
                    lastfolder = folder;
                    ((OutputStream)vxfileOutputStream).write(new String(pre + md5 + " " + folder + file + "\n").getBytes());
                    continue;
                }
                ((OutputStream)vxfileOutputStream).write(new String(pre + md5 + " " + file + "\n").getBytes());
            } while (rs.next());
            CPW.newRsa.doSignature(vxfile, vxfileOutputStream);
            filesmd5OutputStream.flush();
            ((OutputStream)filesmd5OutputStream).close();
            ++revisioncurrent;
        }
        File vesionfile = new File(this.cpwcontent.getAbsolutePath() + "/" + type + "/version");
        vesionfile.createNewFile();
        FileOutputStream vesionfileOutputStream = new FileOutputStream(vesionfile);
        ((OutputStream)vesionfileOutputStream).write(new String("" + revision).getBytes());
        vesionfileOutputStream.flush();
        ((OutputStream)vesionfileOutputStream).close();
        return true;
    }

    private boolean update(String type) throws FileNotFoundException, IOException, Exception {
        File from = new File(this.newcontent.getAbsolutePath() + "/" + type);
        File to = new File(this.cpwcontent.getAbsolutePath() + "/" + type + "/" + type);
        log.debug((Object)("Stating update from " + from.getAbsolutePath()));
        log.debug((Object)("Destination " + to.getAbsolutePath()));
        this.source.put(type, from.getAbsolutePath());
        this.destination.put(type, to.getAbsolutePath());
        return this.update(type, from, to);
    }

    private boolean update(String type, File from, File to) throws FileNotFoundException, IOException, Exception {
        File[] files;
        if (!from.exists() || from.isDirectory() && !this.createFolder(to)) {
            log.debug((Object)"Some File missed or can't create destination directory.");
            return false;
        }
        for (File srcfile : files = from.listFiles(new CPWFileFilter())) {
            String topath = to.getAbsolutePath() + "/" + this.base64(srcfile.getName());
            if (srcfile.isDirectory()) {
                log.debug((Object)("Entered " + srcfile));
                this.update(type, srcfile, new File(topath));
                if (!Boolean.valueOf(CPW.conf.getProperty("remove-folders", "false")).booleanValue()) continue;
                log.debug((Object)("Removing folder " + srcfile));
                srcfile.delete();
                continue;
            }
            this.pack(srcfile, new File(topath));
            this.updateDatabase(type, CRCSum.getMD5Checksum(topath), this.getFileName(this.getUnpackedFilePath(type, srcfile.getAbsolutePath())), this.getFileName(this.getPackedFilePath(type, topath)), this.getFolderPath(this.getUnpackedFilePath(type, srcfile.getAbsolutePath())), this.getFolderPath(this.getPackedFilePath(type, topath)), new File(topath).length());
            if (!Boolean.valueOf(CPW.conf.getProperty("remove-files", "false")).booleanValue()) continue;
            log.debug((Object)("Removing file " + srcfile));
            srcfile.delete();
        }
        return true;
    }

    public void pack(File fileInput, File fileOutput) throws FileNotFoundException, IOException {
        fileOutput.createNewFile();
        log.debug((Object)("Packing " + fileOutput.getAbsolutePath()));
        FileInputStream fileInputStream = new FileInputStream(fileInput);
        FileOutputStream fileOutputStream = new FileOutputStream(fileOutput);
        byte[] buffer = new byte[(int)fileInput.length()];
        byte[] buffer2 = new byte[(int)fileInput.length()];
        ByteBuffer temp = ByteBuffer.allocate(4);
        temp.order(ByteOrder.LITTLE_ENDIAN);
        temp.putInt((int)fileInput.length());
        int compressedDataLength = (int)fileInput.length();
        log.debug((Object)("Uncompressed size is " + compressedDataLength + " B"));
        ((InputStream)fileInputStream).read(buffer);
        Deflater compresser = new Deflater(1, false);
        compresser.setInput(buffer);
        compresser.finish();
        compressedDataLength = compresser.deflate(buffer2);
        log.debug((Object)("Compressed size is " + compressedDataLength + " B"));
        if (fileInput.length() <= (long)compressedDataLength) {
            buffer2 = buffer;
        }
        ((OutputStream)fileOutputStream).write(temp.array());
        ((OutputStream)fileOutputStream).write(buffer2, 0, compressedDataLength);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        ((InputStream)fileInputStream).close();
    }

    class CPWFileFilter
    implements FilenameFilter {
        CPWFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.compareToIgnoreCase(".svn") != 0 && name.compareToIgnoreCase("_svn") != 0 && name.compareToIgnoreCase("version.sw") != 0 && name.compareToIgnoreCase("Thumbs.db") != 0;
        }
    }
}

