/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.crypt;

import com.pwemu.framework.crypt.Base64;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.log4j.Logger;

public class RsaSha1 {
    private static final Logger log = Logger.getLogger(RsaSha1.class);
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private BigInteger modus;
    private BigInteger privateX;
    private BigInteger publicX;
    private String signatereText = "-----BEGIN ELEMENT SIGNATURE-----\n";

    public RsaSha1() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(1024, random);
            KeyPair pair = keyGen.generateKeyPair();
            this.privateKey = pair.getPrivate();
            this.publicKey = pair.getPublic();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec prks = kf.getKeySpec(this.privateKey, RSAPrivateKeySpec.class);
            this.modus = prks.getModulus();
            this.privateX = prks.getPrivateExponent();
            RSAPublicKeySpec pubks = kf.getKeySpec(this.publicKey, RSAPublicKeySpec.class);
            this.publicX = pubks.getPublicExponent();
        }
        catch (InvalidKeySpecException ex) {
            log.fatal((Object)"Cannot properly initialise RSA algorythm while generating keys. Keyring method not found.", (Throwable)ex);
        }
        catch (NoSuchProviderException ex) {
            log.fatal((Object)"Cannot properly initialise RSA algorythm while generating keys. Keyring provider not found.", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.fatal((Object)"Cannot properly initialise RSA algorythm while generating keys. Keyring algorithm not found.", (Throwable)ex);
        }
    }

    public RsaSha1(BigInteger privateX, BigInteger publicX, BigInteger modus) {
        try {
            this.modus = modus;
            this.privateX = privateX;
            this.publicX = publicX;
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec new_prks = new RSAPrivateKeySpec(this.modus, this.privateX);
            RSAPublicKeySpec new_pubks = new RSAPublicKeySpec(this.modus, this.publicX);
            this.privateKey = kf.generatePrivate(new_prks);
            log.info((Object)("Loaded private key: " + Base64.encodeBytes(this.privateKey.getEncoded()).toString()));
            this.publicKey = kf.generatePublic(new_pubks);
            log.info((Object)("Loaded public key: " + Base64.encodeBytes(this.publicKey.getEncoded()).toString()));
        }
        catch (InvalidKeySpecException ex) {
            log.fatal((Object)"Cannot properly initialise RSA algorythm while loading keys. Keyring method not found.", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            log.fatal((Object)"Cannot properly initialise RSA algorythm while loading keys. Keyring algorithm not found.", (Throwable)ex);
        }
    }

    public String doSignature(String what) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] textBytes = what.getBytes();
        Signature dsa = Signature.getInstance("MD5withRSA");
        dsa.initSign(this.privateKey);
        dsa.update(textBytes);
        byte[] encryptedBytes = dsa.sign();
        String encryptedText = Base64.encodeBytes(encryptedBytes).toString();
        return this.signatereText + encryptedText;
    }

    public boolean doSignature(File what, OutputStream fos) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature dsa = Signature.getInstance("MD5withRSA");
        dsa.initSign(this.privateKey);
        FileInputStream fis = new FileInputStream(what);
        BufferedInputStream bufin = new BufferedInputStream(fis);
        byte[] buffer = new byte[1024];
        while (bufin.available() != 0) {
            int len = bufin.read(buffer);
            dsa.update(buffer, 0, len);
        }
        bufin.close();
        fis.close();
        byte[] realSig = dsa.sign();
        fos.write(this.signatereText.getBytes());
        String signature = Base64.encodeBytes(realSig);
        for (int i = 0; i < signature.length(); i += 64) {
            int b = i + 64;
            if (b > signature.length()) {
                b = signature.length();
            }
            fos.write(new String(signature.substring(i, b) + "\n").getBytes());
        }
        return true;
    }

    public void printKeys() {
        System.out.println("Loaded public key: " + Base64.encodeBytes(this.publicKey.getEncoded()).toString());
        System.out.println("Loaded private key: " + Base64.encodeBytes(this.privateKey.getEncoded()).toString());
    }

    public String getModus() {
        return this.modus.toString();
    }

    public String getPublicX() {
        return this.publicX.toString();
    }

    public String getPrivateX() {
        return this.privateX.toString();
    }

    public String getPrivateKey() {
        return Base64.encodeBytes(this.privateKey.getEncoded()).toString();
    }

    public String getPublicKey() {
        return Base64.encodeBytes(this.publicKey.getEncoded()).toString();
    }

    public void patchFile(File f) throws IOException {
        try {
            File nf = new File(f.getPath());
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[(int)f.length()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            byte[] pub = Base64.encodeBytesToBytes(this.publicKey.getEncoded());
            String file = new String(buffer, "ISO-8859-1");
            int pubposition = file.indexOf("-----BEGIN PUBLIC KEY-----");
            if (pubposition == -1) {
                return;
            }
            log.info((Object)("Found key at " + (pubposition += 27)));
            StringBuilder content = new StringBuilder();
            content.append(new String(pub, 0, 64));
            content.append("\n");
            content.append(new String(pub, 64, 64));
            content.append("\n");
            content.append(new String(pub, 128, 64));
            content.append("\n");
            content.append(new String(pub, 192, 24));
            int i2 = 0;
            byte[] key = content.toString().getBytes();
            for (int i = pubposition; i < pubposition + 219; ++i) {
                buffer[i] = key[i2];
                ++i2;
            }
            f.renameTo(new File(f.getPath() + ".bak"));
            FileOutputStream fos = new FileOutputStream(nf);
            ((OutputStream)fos).write(buffer);
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

