/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.nio.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileBackup {
    private File input = null;
    private File output = null;
    private String postfix = ".bak";

    public FileBackup(String input) {
        this.input = new File(input);
    }

    public FileBackup(File input) {
        this.input = input;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void start() throws FileNotFoundException, IOException {
        if (!this.input.exists() || !this.input.isFile()) {
            return;
        }
        this.output = this.findFreeName();
        this.output.createNewFile();
        FileChannel channelInput = new FileInputStream(this.input).getChannel();
        FileChannel channelOutput = new FileInputStream(this.output).getChannel();
        channelInput.transferTo(0L, channelInput.size(), channelOutput);
        channelInput.close();
        channelOutput.close();
        channelOutput = null;
        channelInput = null;
    }

    private File findFreeName() throws IOException {
        File temp = new File(this.input.getName() + this.postfix);
        while (temp.exists()) {
            temp = new File(temp.getName() + this.postfix);
        }
        return temp;
    }
}

