/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.nio.streams;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class LittleEndianInputStream
extends FilterInputStream {
    private MappedByteBuffer mbb;
    private static byte[][] codetable = new byte[256][256];

    public LittleEndianInputStream(String in) throws FileNotFoundException, IllegalArgumentException, IOException {
        this(new FileInputStream(in));
    }

    public LittleEndianInputStream(File in) throws FileNotFoundException, IllegalArgumentException, IOException {
        this(new FileInputStream(in));
    }

    public LittleEndianInputStream(FileInputStream in) throws IllegalArgumentException, IOException {
        super(in);
        this.mbb = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, in.getChannel().size());
        this.mbb.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int read() throws IOException {
        if (this.mbb.hasRemaining()) {
            return this.mbb.get();
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        if (this.mbb.hasRemaining()) {
            this.mbb.get(b);
            return b.length;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mbb.hasRemaining()) {
            this.mbb.get(b, off, len);
            return b.length - off;
        }
        return -1;
    }

    public final boolean readBoolean() throws IOException {
        int bool = this.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    public final byte readByte() throws IOException {
        int temp = this.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public final byte[] readBytes(int numbytes) throws IOException {
        byte[] result = new byte[numbytes];
        for (int i = 0; i < numbytes; ++i) {
            int temp = this.read();
            if (temp == -1) {
                throw new EOFException();
            }
            result[i] = (byte)temp;
        }
        return result;
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    public final short readShort() throws IOException {
        return this.mbb.getShort();
    }

    public final int readInt() throws IOException {
        return this.mbb.getInt();
    }

    public final long readLong() throws IOException {
        return this.mbb.getLong();
    }

    public final float readFloat() throws IOException {
        return this.mbb.getFloat();
    }

    public final double readDouble() throws IOException {
        return this.mbb.getDouble();
    }

    public final char readChar() throws IOException {
        return this.mbb.getChar();
    }

    public final char[] readChars(int numchars) throws IOException {
        char[] result = new char[numchars];
        for (int i = 0; i < numchars; ++i) {
            result[i] = this.readChar();
        }
        return result;
    }

    public String readString(int length) throws IOException {
        byte[] result = new byte[length];
        this.read(result);
        return new String(result);
    }

    public String readString() throws IOException {
        short length = this.readShort();
        System.err.println(length);
        byte[] result = new byte[length];
        this.read(result);
        return new String(result, "GB18030");
    }

    public String readUnicodeString(int length) throws IOException {
        byte[] result = new byte[length];
        this.read(result);
        return new String(result, "UTF-16LE");
    }

    public String readUnicodeString() throws IOException {
        short length = this.readShort();
        byte[] result = new byte[length];
        this.read(result);
        return new String(result, "UTF-16LE");
    }

    public String readUnicodeStringTask(byte[] bid, int lenght) throws IOException {
        int pp;
        byte[] btext = new byte[lenght];
        this.read(btext);
        ArrayList<Byte> key1 = new ArrayList<Byte>();
        ArrayList<Byte> key2 = new ArrayList<Byte>();
        for (int i = 0; i < 256; ++i) {
            int key0 = bid[0];
            if (key0 < 0) {
                key0 += 256;
            }
            key1.add(codetable[i][key0]);
            key2.add(codetable[i][bid[1]]);
        }
        for (int i = pp = 0; i < btext.length; i += 2) {
            if (btext.length % 2 == 0) {
                btext[i] = (byte)key1.indexOf(btext[i]);
                btext[i + 1] = (byte)key2.indexOf(btext[i + 1]);
                continue;
            }
            btext[i] = (byte)key2.indexOf(btext[i]);
            if (i + 2 >= btext.length) continue;
            btext[i + 1] = (byte)key1.indexOf(btext[i + 1]);
        }
        String str = new String(btext, "UTF-16LE");
        return str;
    }

    public long skip(long length) throws ClosedChannelException, IllegalArgumentException, IOException {
        this.mbb.position((int)(this.position() + length));
        return this.position() + length;
    }

    public void position(long newPosition) throws ClosedChannelException, IllegalArgumentException, IOException {
        if (newPosition < 0L) {
            newPosition = this.position() + newPosition;
        }
        this.mbb.position((int)newPosition);
    }

    public long position() throws ClosedChannelException, IOException {
        return this.mbb.position();
    }

    public synchronized void rewind() {
        this.mbb.rewind();
    }

    public long size() throws ClosedChannelException, IOException {
        return this.mbb.capacity();
    }

    protected void finalize() throws Throwable {
        this.mbb = null;
        super.finalize();
    }

    static {
        int step = 255;
        for (int y = 0; y < 256; ++y) {
            LittleEndianInputStream.codetable[0][y] = (byte)y;
        }
        for (int x = 1; x < 256; ++x) {
            int h = 7;
            while ((double)x % Math.pow(2.0, h) != 0.0) {
                --h;
            }
            step = 2 * (int)Math.pow(2.0, h);
            for (int y = 0; y < 256; y += step) {
                for (int z = 1; z <= step; ++z) {
                    LittleEndianInputStream.codetable[x][y + z - 1] = codetable[x - 1][y + step - z];
                }
            }
        }
    }
}

