/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.servise;

import com.pwemu.framework.servise.log4j.JuliToLog4JHandler;
import com.pwemu.framework.servise.log4j.ThrowableAsMessageAwareFactory;
import com.pwemu.framework.servise.log4j.exceptions.Log4jInitializationError;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggingService {
    public static final String LOGGER_FACTORY_CLASS_PROPERTY = "log4j.loggerfactory";
    public static final String LOGGER_CONFIG_FILE = "config/log4j.xml";
    private static boolean initialized;

    public static void init() throws Log4jInitializationError {
        File f = new File(LOGGER_CONFIG_FILE);
        if (!f.exists()) {
            throw new Log4jInitializationError("Missing file " + f.getPath());
        }
        try {
            LoggingService.init(f.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new Log4jInitializationError("Can't initalize logging", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(URL url) throws Log4jInitializationError {
        Class<LoggingService> clazz = LoggingService.class;
        synchronized (LoggingService.class) {
            if (initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                DOMConfigurator.configure((URL)url);
            }
            catch (Exception e) {
                throw new Log4jInitializationError("Can't initialize logging", e);
            }
            LoggingService.overrideDefaultLoggerFactory();
            Logger logger = LogManager.getLogManager().getLogger("");
            for (Handler h : logger.getHandlers()) {
                logger.removeHandler(h);
            }
            logger.addHandler(new JuliToLog4JHandler());
            return;
        }
    }

    private static void overrideDefaultLoggerFactory() {
        Hierarchy lr = (Hierarchy)org.apache.log4j.LogManager.getLoggerRepository();
        try {
            Field field = lr.getClass().getDeclaredField("defaultFactory");
            field.setAccessible(true);
            String cn = System.getProperty(LOGGER_FACTORY_CLASS_PROPERTY, ThrowableAsMessageAwareFactory.class.getName());
            Class<?> c = Class.forName(cn);
            field.set(lr, c.newInstance());
            field.setAccessible(false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            throw new Log4jInitializationError("Can't found log4j logger factory class", e);
        }
        catch (InstantiationException e) {
            throw new Log4jInitializationError("Can't instantiate log4j logger factory", e);
        }
    }
}

