/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.servise.log4j;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;

public class JuliToLog4JHandler
extends Handler {
    public void publish(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "";
        }
        org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger((String)loggerName);
        org.apache.log4j.Level level = this.toLog4jLevel(record.getLevel());
        log.log(Logger.class.getName(), (Priority)level, (Object)record.getMessage(), record.getThrown());
    }

    protected org.apache.log4j.Level toLog4jLevel(Level juliLevel) {
        if (Level.OFF.equals(juliLevel)) {
            return org.apache.log4j.Level.OFF;
        }
        if (Level.SEVERE.equals(juliLevel)) {
            return org.apache.log4j.Level.ERROR;
        }
        if (Level.WARNING.equals(juliLevel)) {
            return org.apache.log4j.Level.WARN;
        }
        if (Level.INFO.equals(juliLevel)) {
            return org.apache.log4j.Level.INFO;
        }
        if (Level.CONFIG.equals(juliLevel) || Level.FINE.equals(juliLevel)) {
            return org.apache.log4j.Level.DEBUG;
        }
        if (Level.FINER.equals(juliLevel) || Level.FINEST.equals(juliLevel)) {
            return org.apache.log4j.Level.TRACE;
        }
        if (Level.ALL.equals(juliLevel)) {
            return org.apache.log4j.Level.ALL;
        }
        LogLog.warn((String)("Warning: usage of custom JULI level: " + juliLevel.getName()), (Throwable)new Exception());
        return new CustomLog4jLevel(juliLevel.intValue(), juliLevel.getName(), juliLevel.intValue());
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    protected static class CustomLog4jLevel
    extends org.apache.log4j.Level {
        private static final long serialVersionUID = 4014557380173323844L;

        protected CustomLog4jLevel(int level, String levelStr, int syslogEquivalent) {
            super(level, levelStr, syslogEquivalent);
        }
    }
}

