/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.servise.log4j.appenders;

import com.pwemu.framework.servise.log4j.exceptions.AppenderInitializationError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.helpers.LogLog;

public class TruncateToZipFileAppender
extends FileAppender {
    private String backupDir = "log/backup";
    private String backupDateFormat = "yyyy-MM-dd HH-mm-ss";

    public void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        if (!append) {
            this.truncate(new File(fileName));
        }
        super.setFile(fileName, append, bufferedIO, bufferSize);
    }

    protected void truncate(File file) {
        LogLog.debug((String)("Compression of file: " + file.getAbsolutePath() + " started."));
        if (FileUtils.isFileOlder((File)file, (long)ManagementFactory.getRuntimeMXBean().getStartTime())) {
            SimpleDateFormat df;
            File backupRoot = new File(this.getBackupDir());
            if (!backupRoot.exists() && !backupRoot.mkdirs()) {
                throw new AppenderInitializationError("Can't create backup dir for backup storage");
            }
            try {
                df = new SimpleDateFormat(this.getBackupDateFormat());
            }
            catch (Exception e) {
                throw new AppenderInitializationError("Invalid date formate for backup files: " + this.getBackupDateFormat(), e);
            }
            String date = df.format(new Date(file.lastModified()));
            File zipFile = new File(backupRoot, file.getName() + "." + date + ".zip");
            ZipOutputStream zos = null;
            FileInputStream fis = null;
            try {
                int readed;
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setMethod(8);
                entry.setCrc(FileUtils.checksumCRC32((File)file));
                zos.putNextEntry(entry);
                fis = FileUtils.openInputStream((File)file);
                byte[] buffer = new byte[1024];
                while ((readed = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, readed);
                }
            }
            catch (Exception e) {
                throw new AppenderInitializationError("Can't create zip file", e);
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        LogLog.warn((String)"Can't close zip file", (Throwable)e);
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LogLog.warn((String)"Can't close zipped file", (Throwable)e);
                    }
                }
            }
            if (!file.delete()) {
                throw new AppenderInitializationError("Can't delete old log file " + file.getAbsolutePath());
            }
        }
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public String getBackupDateFormat() {
        return this.backupDateFormat;
    }

    public void setBackupDateFormat(String backupDateFormat) {
        this.backupDateFormat = backupDateFormat;
    }
}

