/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.threading;

import java.io.Serializable;
import java.util.Date;

public class Stopwatch
implements Serializable {
    static final long serialVersionUID = -6958796021257440232L;
    private long start;
    private boolean paused;
    private long halted;
    private long end;

    public Stopwatch() {
        this.start = System.currentTimeMillis();
    }

    public Stopwatch(long milliseconds) {
        this.start = System.currentTimeMillis() - milliseconds;
    }

    public Stopwatch(Date time) {
        this.start = time.getTime();
    }

    public Stopwatch(Stopwatch timer) {
        this.synchronize(timer);
    }

    public Stopwatch(boolean isRunning) {
        this();
        if (!isRunning) {
            this.pause();
            this.reset();
        }
    }

    public Stopwatch(long milliseconds, boolean isRunning) {
        if (isRunning) {
            this.start = System.currentTimeMillis() - milliseconds;
        } else {
            this.end = System.currentTimeMillis();
            this.start = this.end - milliseconds;
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void synchronize(Stopwatch timer) {
        Stopwatch stopwatch = timer;
        synchronized (stopwatch) {
            this.start = timer.getStartTime();
            this.paused = timer.isPaused();
            this.end = timer.getEnd();
            this.halted = timer.getHalted();
        }
    }

    public long getStartTime() {
        return this.start;
    }

    public Date getStartDate() {
        return new Date(this.start);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return !this.paused;
    }

    public synchronized void pause() {
        if (!this.paused) {
            this.end = System.currentTimeMillis();
            this.paused = true;
        }
    }

    public synchronized void resume() {
        if (this.paused) {
            this.halted += System.currentTimeMillis() - this.end;
            this.end = 0L;
            this.paused = false;
        }
    }

    public synchronized void start() {
        this.halted = System.currentTimeMillis() - this.start;
        this.paused = false;
        this.end = 0L;
    }

    public synchronized long stop() {
        long t = this.elapsed();
        this.pause();
        this.reset();
        return t;
    }

    public synchronized void reset() {
        this.start = System.currentTimeMillis();
        if (this.paused) {
            this.end = this.start;
        }
        this.halted = 0L;
    }

    public synchronized void reset(long milliseconds) {
        if (this.paused) {
            this.start = System.currentTimeMillis() - milliseconds;
            this.end = this.start + milliseconds;
            this.halted = 0L;
        } else {
            this.restart(milliseconds);
        }
    }

    public synchronized void restart() {
        this.start = System.currentTimeMillis();
        this.halted = 0L;
        this.end = 0L;
        this.paused = false;
    }

    public synchronized void restart(long milliseconds) {
        this.start = System.currentTimeMillis();
        this.halted = -milliseconds;
        this.end = 0L;
        this.paused = false;
    }

    public synchronized long elapsed() {
        if (this.paused) {
            return this.end - this.start - this.halted;
        }
        return System.currentTimeMillis() - this.start - this.halted;
    }

    public String elapsedAsString() {
        return Stopwatch.timeAsString(this.elapsed());
    }

    public String display() {
        return Stopwatch.timeAsStringShort(this.elapsed());
    }

    public static String timeAsString(long milliSecs) {
        String s = "";
        int days = (int)(milliSecs / 86400000L);
        int hours = (int)(milliSecs % 86400000L) / 3600000;
        int minutes = (int)(milliSecs % 3600000L) / 60000;
        double seconds = (double)(milliSecs % 60000L) / 1000.0;
        if (days != 0) {
            s = s + days + " days, ";
        }
        if (hours != 0) {
            s = s + hours + " h, ";
        }
        if (minutes != 0) {
            s = s + minutes + " min, ";
        }
        s = s + seconds + " sec";
        return s;
    }

    public static String timeAsStringShort(long milliSecs) {
        int hours = Math.abs((int)milliSecs / 3600000);
        int minutes = Math.abs((int)(milliSecs % 3600000L) / 60000);
        int seconds = Math.abs((int)(milliSecs % 60000L) / 1000);
        String s = hours + ":";
        s = s + (minutes < 10 ? "0" + minutes : String.valueOf(minutes));
        s = s + ":";
        s = s + (seconds < 10 ? "0" + seconds : String.valueOf(seconds));
        if (milliSecs < 0L) {
            s = "-" + s;
        }
        return s;
    }

    public String toString() {
        String s = "elapsed time: ";
        s = s + this.elapsedAsString();
        s = this.paused ? s + " (time paused)" : s + " (time running)";
        return s;
    }

    protected long getHalted() {
        return this.halted;
    }

    protected long getEnd() {
        return this.end;
    }
}

