/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.threading;

import com.pwemu.framework.threading.ThreadWorker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.Executor;

public class ThreadPool
implements Executor {
    ArrayList<ThreadWorker> threads;
    Vector<ThreadWorker.Listener> listener;
    ThreadGroup threadGroup;
    boolean daemon;

    public ThreadPool(int numberOfThreads) {
        this(numberOfThreads, false);
    }

    public ThreadPool(int numberOfThreads, boolean asDaemon) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("Number of threads must be greater than 0. " + numberOfThreads + " passed.");
        }
        this.listener = new Vector();
        this.threadGroup = new ThreadGroup("ThreadPool group");
        this.threads = new ArrayList(numberOfThreads);
        this.daemon = asDaemon;
        for (int i = 0; i < numberOfThreads; ++i) {
            this.addThreadWorker();
        }
    }

    public boolean isActive() {
        for (ThreadWorker tw : this.threads) {
            if (!tw.isAlive()) continue;
            return true;
        }
        return false;
    }

    public synchronized int getNumberOfThreads() {
        return this.threads.size();
    }

    public synchronized void addThreadWorker() {
        ThreadWorker tw = new ThreadWorker(this.threadGroup, "ThreadWorker" + this.threads.size());
        tw.setDaemon(this.daemon);
        tw.start();
        tw.addListener(new ThreadWorker.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskPerformed(Runnable task, long timeTaken, Throwable exceptionIfAny) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    Iterator<ThreadWorker.Listener> it = ThreadPool.this.listener.iterator();
                    while (it.hasNext()) {
                        it.next().taskPerformed(task, timeTaken, exceptionIfAny);
                    }
                }
            }
        });
        this.threads.add(tw);
    }

    public synchronized int idleThreads() {
        int count = 0;
        for (ThreadWorker tw : this.threads) {
            if (tw.getQueueSize() != 0) continue;
            ++count;
        }
        return count;
    }

    public synchronized void removeIdleThreads() {
        Iterator<ThreadWorker> i = this.threads.iterator();
        while (i.hasNext()) {
            ThreadWorker tw = i.next();
            if (tw.getQueueSize() != 0) continue;
            tw.endAfterLast();
            i.remove();
        }
    }

    public synchronized boolean removeIdleThread() {
        if (this.threads.size() < 1) {
            return false;
        }
        Iterator<ThreadWorker> i = this.threads.iterator();
        while (i.hasNext()) {
            ThreadWorker tw = i.next();
            if (tw.getQueueSize() != 0) continue;
            tw.endAfterLast();
            i.remove();
            return true;
        }
        return false;
    }

    public synchronized void finishAll(boolean now) {
        Iterator<ThreadWorker> i = this.threads.iterator();
        while (i.hasNext()) {
            if (now) {
                i.next().endAfterCurrent();
            } else {
                i.next().endAfterLast();
            }
            i.remove();
        }
    }

    public synchronized int getQueueSize() {
        int count = 0;
        for (ThreadWorker tw : this.threads) {
            count += tw.getQueueSize();
        }
        return count;
    }

    public synchronized void addListener(ThreadWorker.Listener listener) {
        this.listener.add(listener);
    }

    public synchronized ThreadWorker.Listener[] getListeners() {
        return this.listener.toArray(new ThreadWorker.Listener[this.listener.size()]);
    }

    public synchronized void removeListener(ThreadWorker.Listener listener) {
        this.listener.remove(listener);
    }

    public void execute(Runnable task) {
        this.runTask(task);
    }

    public synchronized void runTask(Runnable task) throws IllegalStateException {
        if (this.threads.size() < 1) {
            throw new IllegalStateException("No threads in pool.");
        }
        int min = Integer.MAX_VALUE;
        ThreadWorker t = this.threads.get(0);
        for (ThreadWorker tw : this.threads) {
            int n = tw.getQueueSize();
            if (n == 0) {
                tw.runTask(task);
                return;
            }
            if (min <= n) continue;
            min = n;
            t = tw;
        }
        t.runTask(task);
    }
}

