/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.threading;

import com.pwemu.framework.threading.Stopwatch;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.Executor;

public class ThreadWorker
extends Thread
implements Executor {
    ArrayList<Runnable> tasks = new ArrayList();
    ArrayList<Listener> listeners = new ArrayList();
    boolean enabled = true;
    boolean endNow = false;
    int count = 0;
    Stopwatch totalRunningTime = new Stopwatch(false);
    Stopwatch currentTaskTime = new Stopwatch(-1L, false);
    boolean once = false;

    public ThreadWorker() {
    }

    public ThreadWorker(String name) {
        super(name);
    }

    public ThreadWorker(ThreadGroup group, String name) {
        super(group, name);
    }

    public synchronized boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public synchronized boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public synchronized Listener[] getListeners() {
        return this.listeners.toArray(new Listener[this.listeners.size()]);
    }

    public synchronized Runnable getCurrentTask() {
        return this.tasks.isEmpty() ? null : this.tasks.get(0);
    }

    public synchronized int getQueueSize() {
        return this.tasks.size();
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty();
    }

    public synchronized Runnable[] getTasks() {
        return this.tasks.toArray(new Runnable[this.tasks.size()]);
    }

    public synchronized boolean removeTask(Runnable task) throws IllegalStateException {
        Runnable r = this.getCurrentTask();
        if (r == null) {
            return false;
        }
        if (r.equals(task)) {
            throw new IllegalStateException("given task is currently active");
        }
        return this.tasks.remove(task);
    }

    public int getTaskCount() {
        return this.count;
    }

    public long getTotalRunningTime() {
        return this.totalRunningTime.elapsed();
    }

    public long getCurrentTaskRunningTime() {
        return this.currentTaskTime.elapsed();
    }

    public void execute(Runnable task) {
        this.runTask(task);
    }

    public synchronized int runTask(Runnable task) throws IllegalStateException {
        if (this.endNow) {
            throw new IllegalStateException("ThreadWorker has been ended after current");
        }
        if (this.once && !this.isAlive()) {
            throw new IllegalStateException("ThreadWorker already finished");
        }
        if (this.tasks.isEmpty()) {
            this.notifyAll();
        }
        this.tasks.add(task);
        return this.tasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IllegalThreadStateException {
        ThreadWorker threadWorker = this;
        synchronized (threadWorker) {
            if (!this.isAlive()) {
                throw new IllegalThreadStateException();
            }
            if (this.once) {
                throw new IllegalThreadStateException();
            }
            this.once = true;
        }
        this.totalRunningTime.restart();
        while (!this.endNow) {
            Runnable currentTask = null;
            ThreadWorker threadWorker2 = this;
            synchronized (threadWorker2) {
                this.currentTaskTime = new Stopwatch(-1L, false);
                if (this.tasks.isEmpty()) {
                    if (!this.enabled) {
                        break;
                    }
                    try {
                        this.totalRunningTime.pause();
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        this.totalRunningTime.resume();
                    }
                } else {
                    currentTask = this.tasks.get(0);
                }
            }
            if (currentTask == null) continue;
            Throwable throwable = null;
            ++this.count;
            this.currentTaskTime.restart();
            try {
                currentTask.run();
            }
            catch (Throwable th) {
                throwable = th;
            }
            finally {
                this.currentTaskTime.pause();
                ThreadWorker ex = this;
                synchronized (ex) {
                    Iterator<Listener> i = this.listeners.iterator();
                    while (i.hasNext()) {
                        i.next().taskPerformed(currentTask, this.currentTaskTime.elapsed(), throwable);
                    }
                    this.currentTaskTime.reset(-1L);
                    this.tasks.remove(0);
                }
            }
        }
    }

    public synchronized void endAfterLast() {
        this.enabled = false;
        if (this.isIdle()) {
            this.notifyAll();
        }
    }

    public synchronized void endAfterCurrent() {
        this.endNow = true;
        if (this.isIdle()) {
            this.notifyAll();
        }
    }

    public boolean willEndAfterCurrent() {
        return this.endNow;
    }

    public boolean willEndAfterLast() {
        return !this.enabled;
    }

    public static interface Listener
    extends EventListener {
        public void taskPerformed(Runnable var1, long var2, Throwable var4);
    }
}

