/*
 * Decompiled with CFR 0.152.
 */
package com.pwemu.framework.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Config {
    private static final Logger log = Logger.getLogger(Config.class);
    private Properties properties;
    private FileInputStream fis;
    private String file;

    private Config(FileInputStream location, String file) {
        this.fis = location;
        this.file = file;
        this.properties = new Properties();
        try {
            this.properties.load(this.fis);
        }
        catch (IOException ex) {
            log.error((Object)"IO Error happend while loading config. ", (Throwable)ex);
        }
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public String getProperty(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public Config save() {
        try {
            this.fis.close();
            FileOutputStream fos = new FileOutputStream(this.file);
            this.properties.store(fos, "Client Updater");
            fos.close();
        }
        catch (IOException ex) {
            log.fatal((Object)"IO Error happend while saving config. ", (Throwable)ex);
        }
        return Config.getConfig(this.file);
    }

    public static Config getConfig(String location) {
        try {
            FileInputStream fis = new FileInputStream(location);
            return new Config(fis, location);
        }
        catch (FileNotFoundException ex) {
            log.fatal((Object)("Cannot load config file " + location), (Throwable)ex);
            return null;
        }
    }
}

